unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, FileCtrl, Jpeg, Menus;

type
  TForm1 = class(TForm)
    PopupMenu1: TPopupMenu;
    Ustawjakotapetpulpitu1: TMenuItem;
    Zamknij1: TMenuItem;
    Panel1: TPanel;
    DirectoryListBox1: TDirectoryListBox;
    FileListBox1: TFileListBox;
    Splitter1: TSplitter;
    Image1: TImage;
    Panel2: TPanel;
    DriveComboBox1: TDriveComboBox;
    procedure FileListBox1DblClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Zamknij1Click(Sender: TObject);
    procedure FileListBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var katalog :array[0..MAX_PATH-1] of Char;
begin
GetWindowsDirectory(katalog,MAX_PATH);
if DirectoryExists(katalog+'\WEB\Wallpaper') then StrCat(katalog,'\WEB\Wallpaper');
FileListBox1.Directory:=katalog;
end;

procedure TForm1.FileListBox1Change(Sender: TObject);
var jpeg :TJPEGImage;
begin
//if (FileListBox1.FileName<>'') and (FileExists(FileListBox1.FileName)) then Image1.Picture.LoadFromFile(FileListBox1.FileName);
if (FileListBox1.FileName<>'') and (FileExists(FileListBox1.FileName)) then
  if ExtractFileExt(FileListBox1.FileName)='.bmp' then Image1.Picture.LoadFromFile(FileListBox1.FileName);
  if (ExtractFileExt(FileListBox1.FileName)='.jpg') or (ExtractFileExt(FileListBox1.FileName)='.jpeg') then
    begin
    jpeg:=TJPEGImage.Create;
    jpeg.LoadFromFile(FileListBox1.FileName);
    Image1.Picture.Bitmap.Assign(jpeg); //do Picture.Bitmap, a nie do Bitmap, aby mozna bylo zapisac potem do pliku .bmp
    end;
end;

procedure TForm1.Zamknij1Click(Sender: TObject);
begin
Close;
end;

procedure TForm1.FormResize(Sender: TObject);
var wys :Integer;
begin
wys:=(Panel1.Height-Panel2.Height) div 2;
DirectoryListBox1.Height:=wys;
FileListBox1.Height:=wys;
end;

procedure TForm1.FileListBox1DblClick(Sender: TObject);
const nazwaKonwersji='tapeta.bmp';
var nazwaPliku :String;
begin
nazwaPliku:=FileListBox1.FileName;
if (nazwaPliku<>'') and (FileExists(nazwaPliku)) then
  begin
  if (ExtractFileExt(FileListBox1.FileName)='.jpg') or (ExtractFileExt(FileListBox1.FileName)='.jpeg') then
    begin
    nazwaPliku:=ExtractFileDir(Application.ExeName)+'\'+nazwaKonwersji;
    Image1.Picture.SaveToFile(nazwaPliku);
    end;
  SystemParametersInfo(SPI_SETDESKWALLPAPER,0,PChar(nazwaPliku),SPIF_UPDATEINIFILE or SPIF_SENDWININICHANGE);
  end;
end;

end.
